import 'package:dio/dio.dart';
import 'package:razinsoft_rider/domain/interfaces/rating_service_interface.dart';

import '../../core/config/api_endpoints.dart';
import 'api/dio_client.dart';

class RatingService implements IRatingService {
  final DioClient dioClient;

  RatingService({required this.dioClient});
  @override
  Future<Response> rating({required double rating, String? comment, required int? orderId}) async => await dioClient.dio
        .post(ApiEndpoints.rating, data: {'rating': rating, 'comment': comment, 'order_id': orderId});

}
